<?php
/**
 * Status Mask
 * Jeremiah Johnson
 * http://jwjdev.com/
 */

if(!defined("IN_MYBB"))
{
    die("You Cannot Access This File Directly");
}

$plugins->add_hook("member_profile_end", "status_mask_member_profile_end");
$plugins->add_hook("online_user", "status_mask_online_user");
//$plugins->add_hook("misc_start", "status_mask_misc_start");
$plugins->add_hook("build_friendly_wol_location_end", "status_mask_build_friendly_wol_location_end");

//$location_name
function status_mask_info()
{
return array(
        "name"  => "هاك اخفاء مكان التواجد",
        "description"=> "تستطيع اخفاء مكان تواجدك في صفحة المتواجدون الان وايضا اي مجموعة تختارها",
        "website"        => "http://jwjdev.com/",
        "author"        => "Jeremiah Johnson",
        "authorsite"    => "http://jwjdev.com/",
        "version"        => "1.0",
        "guid"             => "2cf40e98f942b039cea3d2ff24fa3b66",
        "compatibility" => "16*"
    );
}

function status_mask_is_installed() {
   global $db;

   $query = $db->simple_select("settinggroups", "name", "name='status_mask'");

   $result = $db->fetch_array($query);

   if($result) {
	return 1;
   } else {
	return 0;
   }
}

function status_mask_install() {
   global $db;

   $setting_group = array(
		'gid'			=> 'NULL',
		'name'			=> 'status_mask',
		'title'			=> 'هاك اخفاء مكان تواجدي',
		'description'	=> 'اعدادات هاك اخفاء مكان تواجدي.',
		'disporder'		=> "99",
		'isdefault'		=> 'no',
	);

   $db->insert_query('settinggroups', $setting_group);
   $gid = $db->insert_id();

   $myplugin_setting = array(
		'name'			=> 'status_mask_on',
		'title'			=> 'تفعيل / ايقاف',
		'description'	=> 'اختار هل تريد تشغيل الهاك وايقافه',
		'optionscode'	=> 'yesno', //this will be a yes/no select box
		'value'			=> '1', //default value is yes, use 0 for no
		'disporder'		=> 1,
		'gid'			=> intval($gid),
	);

   $db->insert_query('settings', $myplugin_setting);

   $myplugin_setting = array(
		'name'			=> 'status_mask_allowed_groups',
		'title'			=> 'تفعيل المجموعات',
		'description'	=> 'اختار المجموعات التي تريد ان تفعل الهاك لها مثل الادارة او اي مجموعة اخري .',
		'optionscode'	=> 'text', //this will be a yes/no select box
		'value'			=> '', //default value is yes, use 0 for no
		'disporder'		=> 2,
		'gid'			=> intval($gid),
	);

   $db->insert_query('settings', $myplugin_setting);

   $myplugin_setting = array(
		'name'			=> 'status_mask_mask_text',
		'title'			=> 'رسالة الاخفاء',
		'description'	=> 'اكتب هنا رسالة تظهر في خانة التواجد بصفحة المتواجدون الان.',
		'optionscode'	=> 'text',
		'value'			=> 'المكان مختفي',
		'disporder'		=> 5,
		'gid'			=> intval($gid),
	);

   $db->insert_query('settings', $myplugin_setting);

   rebuild_settings();
}

function status_mask_uninstall()
{
	global $db;
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN ('status_mask_on','status_mask_allowed_groups','status_mask_mask_text')");
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='status_mask'");
	rebuild_settings();
}

//mask from profile
function status_mask_member_profile_end() {
   global $online_status;
   global $memprofile;
   global $mybb;
   global $lang;
   global $db;
   global $uid;
   global $templates;

   //if status mask is even enabled
   if($mybb->settings['status_mask_on']) {
      // User is currently online and this user has permissions to view the user on the WOL
      $timesearch = TIME_NOW - $mybb->settings['wolcutoffmins']*60;
      $query = $db->simple_select("sessions", "location,nopermission", "uid='$uid' AND time>'{$timesearch}'", array('order_by' => 'time', 'order_dir' => 'DESC', 'limit' => 1));
      $session = $db->fetch_array($query);

      //we only have to handle the case where the user is online
      //also check status mask permissions
      if(($memprofile['invisible'] != 1 || $mybb->usergroup['canviewwolinvis'] == 1 || $memprofile['uid'] == $mybb->user['uid']) && !empty($session) && status_mask_check_permissions($memprofile))
      {
         // Fetch their current location
         $lang->load("online");
         //replace normal location with our own
         $masktext = $mybb->settings['status_mask_mask_text'];
         $location = '<a href="' . $mybb->settings['bburl'] . '">' . $masktext . '</a>';
         $location_time = my_date($mybb->settings['timeformat'], $memprofile['lastactive']);

         eval("\$online_status = \"".$templates->get("member_profile_online")."\";");
      }
   }
}

//mask from who's online
function status_mask_online_user() {
   global $user;
   global $mybb;
   global $db;

   if($mybb->settings['status_mask_on']) {
      //we have to do this in order to fetch additional groups as well
      $query = $db->simple_select("users", "uid,usergroup,additionalgroups", "uid=" . $user['uid'], array('limit' => 1));
      $user2 = $db->fetch_array($query);

      //if we need to mask this user's location
      if(status_mask_check_permissions($user2)) {
         //use status mask as location
         $user['location'] = "statusmask";
      }
   }
}

//mask wol
function status_mask_build_friendly_wol_location_end(&$plugin_array) {
   global $mybb;

   if($mybb->settings['status_mask_on']) {
      $user_activity = $plugin_array['user_activity'];

      if($user_activity['activity'] == "index" && $user_activity['location'] == "statusmask") {
         $masktext = $mybb->settings['status_mask_mask_text'];
         $plugin_array['location_name'] = '<a href="' . $mybb->settings['bburl'] . '">' . $masktext . '</a>';
      }

   }
}

//check if we should mask this user
function status_mask_check_permissions($user) {
   global $mybb;
   $allowed = false;

   if(strlen(trim($mybb->settings['status_mask_allowed_groups'])) > 0) { //if allowed groups is set
      $allowedGroups = explode(",", $mybb->settings['status_mask_allowed_groups']);
      for($i = 0; $i < sizeof($allowedGroups); $i++) { //trim allowed groups
         $allowedGroups[$i] = trim($allowedGroups[$i]);
      }
	  $userGroup = $user['usergroup'];
	  if(in_array($userGroup, $allowedGroups)) { //check primary usergroups
	     $allowed = true;
	  } else { //check additional user groups
	     $addGroups = explode(",", $user['additionalgroups']);
		 foreach($addGroups as $checkGroup) {
		    if(in_array($checkGroup, $allowedGroups)) {
			   $allowed = true;
			}
		 }
      }
   } else {
      $allowed = false;
   }
   return $allowed;
}
?>
